<?php

/* -----------------------------------------------------------------
 * 	$Id: shopping24.php 717 2013-11-05 15:38:31Z akausch $
 * 	Copyright (c) 2011-2021 commerce:SEO by Webdesign Erfurt
 * 	http://www.commerce-seo.de
 * ------------------------------------------------------------------
 * 	based on:
 * 	(c) 2000-2001 The Exchange Project  (earlier name of osCommerce)
 * 	(c) 2002-2003 osCommerce - www.oscommerce.com
 * 	(c) 2003     nextcommerce - www.nextcommerce.org
 * 	(c) 2005     xt:Commerce - www.xt-commerce.com
 * 	(c) 2013     Gambio GmbH - www.gambio.de
 * 	Released under the GNU General Public License
 * --------------------------------------------------------------- */

class Shopping24 {

    var $v_export_type;
    var $v_module_name;
    var $v_module_homepage;
    var $v_module_format;
    var $v_module_export_filename;
    var $v_filename;
    var $v_keyname;
    var $v_linkname;
    var $v_delimiter;
    var $v_enclosure;
    var $v_field_filename;
    var $v_field_customers_groups;
    var $v_field_currency;
    var $v_field_shipping_costs;
    var $v_field_shipping_costs_free;
    var $v_field_attributes;
    var $v_field_campaign;
    var $v_field_export;

    function Shopping24() {
        $this->formSettings();
    }

    function formSettings() {
        $this->v_export_type = 'comparison';
        $this->v_module_name = 'Shopping24';
        $this->v_module_homepage = 'www.shopping24.de';
        $this->v_module_format = 'txt';
        $this->v_module_export_filename = 'shopping24.csv';
        $this->v_filename = 'shopping24.php';
        $this->v_keyname = 'SHOPPING24';
        $this->v_linkname = 'shopping24';
        $this->v_delimiter = "|";
        $this->v_enclosure = '';
        $this->v_field_filename = true;
        $this->v_field_customers_groups = true;
        $this->v_field_currency = true;
        $this->v_field_shipping_costs = true;
        $this->v_field_shipping_costs_free = true;
        $this->v_field_attributes = true;
        $this->v_field_campaign = true;
        $this->v_field_export = true;
    }

    function formAddOn() {
        
    }

    function formatResults($p_products_array) {
        $p_products_array['manufacturers_name'] = strtoupper(str_replace(" ", "", $p_products_array['manufacturers_name']));
        $p_products_array['products_price'] = number_format((double) $p_products_array['products_price'], 2, '.', '');
        $p_products_array['products_shipping_costs'] = number_format((double) $p_products_array['products_shipping_costs'], 2, '.', '');
        return($p_products_array);
    }

    function exportScheme() {
        $t_csv_fields_array = array();
        $t_csv_fields_array['products_id'] = 'art_number';
        $t_csv_fields_array['products_name'] = 'art_name';
        $t_csv_fields_array['products_description'] = 'art_description';
        $t_csv_fields_array['products_image_1'] = 'image_url';
        $t_csv_fields_array['products_link'] = 'deep_link';
        $t_csv_fields_array['products_price'] = 'price';
        $t_csv_fields_array['products_currency'] = 'currency';
        $t_csv_fields_array['products_shipping_costs'] = 'delivery_costs';
        $t_csv_fields_array['products_categories'] = 'category';
        $t_csv_fields_array['manufacturers_name'] = 'brand';
        $t_csv_fields_array['products_sex'] = 'gender';
        $t_csv_fields_array['products_color'] = 'color';
        $t_csv_fields_array['products_ean'] = 'ean';
        $t_csv_fields_array['retail_price'] = 'old_price';
        $t_csv_fields_array['products_size'] = 'clothing_size';
        $t_csv_fields_array['products_material'] = 'material';
        $t_csv_fields_array['products_format'] = 'look';
        $t_csv_fields_array['products_type'] = 'product_type';
        $t_csv_fields_array['products_size'] = 'size';
        $t_csv_fields_array['products_style'] = 'style';
        $t_csv_fields_array['products_shippingtime'] = 'delivery_time';
        $t_csv_fields_array['manufacturers_name'] = 'manufacturer_code';
        $t_csv_fields_array['products_availability'] = 'availability';
        $t_csv_fields_array['products_image_2'] = 'additional_image_url2';
        $t_csv_fields_array['products_image_3'] = 'additional_image_url3';
        return($t_csv_fields_array);
    }

}

?>